'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Function LoadRibbons()
On Error GoTo SkipRibbons               ' "==>" Zeilen in Access 2007 aktivieren !!!
Dim i As Integer                        ' ==========================================
Dim db As DAO.Database
Set db = Application.CurrentDb
For i = 0 To (db.TableDefs.Count - 1)
    If (InStr(1, db.TableDefs(i).Name, "Ribbons")) Then
        Dim rs As DAO.Recordset
        Set rs = CurrentDb.OpenRecordset(db.TableDefs(i).Name)
        rs.MoveFirst
        While Not rs.EOF
            Application.LoadCustomUI rs("RibbonName").Value, rs("RibbonXml").Value      '<==
            rs.MoveNext
        Wend
        rs.Close
        Set rs = Nothing
    End If
Next i
SkipRibbons:
On Error Resume Next
db.Close
Set db = Nothing
End Function

Public Sub OeffnungsStatus()
'wenn von vertrauenswrdigem Ort gestartet, dann weiter...
If CurrentProject.IsTrusted = True Then                                                 '<==
    DoCmd.Close acForm, "Programmstart_A2007Option", acSaveNo
    DoCmd.OpenForm "Hauptmenue"
End If                                                                                  '<==
End Sub

Public Sub TerminzuordnungZuKalenderPruefen(OrdnerLfdNr As Long, KalEntryID As String, KalStoreID As String)
    Dim FilterTermine As String
    
    Dim rst2 As Recordset
    
    Dim TerminID As String
    Dim TerminOrdner As Object
    Dim TerminObjekt As Object
    
    Dim stDocName As String
    Dim stLinkCriteria As String
    Dim NummeroGesamt As Long
    Dim NummeroTermin As Long
    

    'Nicht-zugeordnete-Kalender haben die Kalendernummer "-1"
    'da die Nummer "0" in der Preistabelle fr die Eigenschaft "kalenderbergreifender Preis" hat!
    FilterTermine = "SELECT * FROM Termine WHERE [lfd_Nr_Kalender] = -1"

    Set rst = dbs.OpenRecordset(FilterTermine)
    If (rst.RecordCount) <> 0 Then
        rst.MoveLast        'Auffllen
        rst.MoveFirst
        
        'Fortschrittsdialog auf den Schirm bringen
        stDocName = "Terminlauf"
        DoCmd.OpenForm stDocName, , , stLinkCriteria
        'Anzeigen fllen
        Forms!Terminlauf.Re_Termin_gesamt.Caption = rst.RecordCount
        Forms!Terminlauf.Caption = "Termine prfen..."
        ShowProgress Forms!Terminlauf.Verlauf_Balken, 1, 100
        NummeroGesamt = rst.RecordCount
        NummeroTermin = 0
        
        Do While (rst.EOF = False)
            'Versuchen, das Element zu finden ---------------------------
            TerminID = rst!Termin_ID
            'Fehlerbehandlung "ausschalten", falls Termin nicht gefunden wird oder Outlook nicht antwortet
            On Error GoTo Termin_Nicht_Vorhanden
            
            Set TerminObjekt = meinNamespace.GetItemFromID(TerminID)
            If TerminObjekt = Empty Then
                'Falls Termin nicht in Outlook, dann eben nicht
            Else
                'Der Termin wurde in Outlook gefunden
                'nun den TerminOrdner ermitteln
                Set TerminOrdner = TerminObjekt.Parent
                'EntryID und StoreID des OutlookOrdners mit dem aktuell hinzugefgten Ordner vergleichen
                If TerminOrdner.EntryID = KalEntryID Then
                    If TerminOrdner.StoreID = KalStoreID Then
                        'zuvor alle Kalendereintrge zum Termin durchgehen
                        FilterTermine = "SELECT * FROM Termine_Kalender WHERE [lfd_Nr_Termin]=" & rst!lfd_Nr
                        Set rst2 = dbs.OpenRecordset(FilterTermine)
                        If rst2.RecordCount <> 0 Then
                            rst2.MoveLast
                            rst2.MoveFirst
                            Do While rst2.EOF = False
                                rst2.Edit
                                rst2!lfd_Nr_Kalender = OrdnerLfdNr
                                rst2.Update
                                rst2.MoveNext
                            Loop
                        End If
                        rst2.Close
                        'eigentlichen Termin aktualisieren
                        rst.Edit
                        rst!lfd_Nr_Kalender = OrdnerLfdNr
                        rst.Update
                        rst.Bookmark = rst.LastModified
                    End If
                End If
                Set TerminOrdner = Nothing
            End If
            
            'Einsprungmarke nach der Fehlerbehandlung, falls der Termin in Outlook nicht existiert
Naechster_Termin:
            
            'Anzeige aktualisieren
            NummeroTermin = NummeroTermin + 1
            ShowProgress Forms!Terminlauf.Verlauf_Balken, NummeroTermin - 1, NummeroGesamt
            Forms!Terminlauf.Re_Termin_aktuell.Caption = NummeroTermin
            Forms!Terminlauf.Re_Termindatum.Caption = rst!Start
            Forms!Terminlauf.Repaint
            

            Set TerminObjekt = Nothing
            rst.MoveNext
        Loop
        'Fortschrittsdialog wieder schlieen
        DoCmd.Close acForm, "Terminlauf", acSaveYes
    End If
    
    rst.Close
    
    
    
    
    Exit Sub

Termin_Nicht_Vorhanden:
    'MsgBox Err.Description
    Resume Naechster_Termin
    
End Sub

Public Sub OutlookElementOeffnen(ElementID As String)
    Dim meinObjekt As Object
    Dim Fehlertext As String
    
    Dim Ziel As String
    Dim Verfolger As Hyperlink
    Dim meinLink As Object
    
    'Versuchen Outlook zu ffnen --------------------------------
    On Error GoTo ErrorOutlookVerbindung
    Set olkAnw = CreateObject("outlook.application")
    Set meinNamespace = olkAnw.GetNamespace("MAPI")
    
    'Versuchen, das Element zu finden ---------------------------
    On Error GoTo ErrorElementFinden
    Set meinObjekt = meinNamespace.GetItemFromID(ElementID)
    If meinObjekt = Empty Then
        Fehlertext = "Das gesuchte Element wurde in Outlook nicht gefunden!" & vbNewLine & vbNewLine & _
            "Wurde es mglicherweise gelscht oder in ein anderes Postfach verschoben?" & vbNewLine & _
            "Wiederholen Sie gegebenenfalls den Menpunkt ""Outlook bernehmen"", um die Daten der Terminabrechnung zu aktualisieren."
        MsgBox Fehlertext, vbCritical + vbOKOnly, "Fehler"
        Exit Sub
    End If
    
    'Versuch, das Element anzuzeigen ----------------------------
    On Error GoTo ErrorElementAnzeigen
    meinObjekt.Display 1            ' Versuch, das Objekt modal zu ffnen, damit es im Fokus bleibt
    
    
    
Exit_OutlookElementOeffnen:
    Exit Sub
    
    
    
ErrorOutlookVerbindung:
    Fehlertext = "Es konnte keine Verbindung zu Ihrem Outlook hergestellt werden!" & vbNewLine & vbNewLine & _
        "Bitte prfen Sie, ob Outlook richtig installiert ist und sich ffnen lsst."
    MsgBox Fehlertext, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_OutlookElementOeffnen
    
ErrorElementFinden:
    If Left(Trim(Str(Abs(err.Number))), 6) = "214722" Then
        'Eigentlich ist diese Meldung an dieser Stelle nicht ganz korrekt, weil ja eine Exeption auftrag,
        'aber was will man machen...
        Fehlertext = "Das gesuchte Element wurde in Outlook nicht gefunden!" & vbNewLine & vbNewLine & _
            "Wurde es mglicherweise gelscht oder in ein anderes Postfach verschoben?" & vbNewLine & _
            "Wiederholen Sie gegebenenfalls den Menpunkt ""Outlook bernehmen"", um die Daten der Terminabrechnung zu aktualisieren."
        MsgBox Fehlertext, vbCritical + vbOKOnly, "Fehler"
        Resume Exit_OutlookElementOeffnen
    End If
    Fehlertext = "Bei dem Versuch das Element in Outlook zu suchen, trat ein Fehler auf!"
    MsgBox Fehlertext, vbCritical + vbOKOnly, "Fehler"
    MsgBox err.Number & ": " & err.Description
    Resume Exit_OutlookElementOeffnen
    
ErrorElementAnzeigen:
    Fehlertext = "Das gefundene Element konnte nicht angezeigt werden!" & vbNewLine & vbNewLine & _
        "Bitte prfen Sie, ob Outlook richtig installiert ist und sich ffnen lsst. " & _
        "Verhindern eventuell Sicherheitseinstellungen das Anzeigen des Elementes?"
    MsgBox Fehlertext, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_OutlookElementOeffnen
    
End Sub

Public Sub ShowProgress(Status As Control, AktDat As Long, AnzDat As Long)
  Dim Proz As Integer

  Proz = Int(AktDat / AnzDat * 100 + 0.5)
  If (Proz < 0) Then Proz = 0
  If (Proz > 100) Then Proz = 100

  Status.Caption = String$(Int(Val(Status.Tag) / 100 * Proz + 0.5), "n")
  
End Sub

Public Sub AnwendungGroesseErmitteln()
    DoCmd.OpenForm "BlankoFormular", acNormal               'Hilfsformular oeffnen
    DoCmd.Maximize                                          '...maximieren
    FormularBreite = Forms![BlankoFormular].InsideWidth     '...Breite und Hoehe ermitteln
    FormularHoehe = Forms![BlankoFormular].InsideHeight
    DoCmd.Close acForm, "BlankoFormular", acSaveNo          '...schlieen
    'ACHTUNG: Das Rckstellen des Fensters auf Normalgre mit "DoCmd.Restore" muss
    '         im Hilfsformular im Ereignis "Unload" erfolgen, da sonst hier die
    '         Breite und Hhe nicht richtig ermittelt werden!
    'Damit es beim Maximieren des Hilfsfensters nicht unntig zu Geruschen und Flackern kommt,
    'sollte in den Bildschirmeigenschaften das "Animieren von Fenstern und Mens" abgeschaltet werden.
End Sub

Public Sub SchriftartFuerBerichtEinstellen(Bericht As Report)
On Error GoTo SchriftartFuerBerichtEinstellen_ERR
    Dim Zahl As Integer
    Dim sec As Section
    Dim ctl As Control

    If SchriftArtWahl = "Times" Then
        'Sectionen durchlaufen
        For Zahl = 0 To 15 Step 1           'Wenn nicht alle Berichtsbereiche in "Times"
                                            'erscheinen, dann den Wert hinter "To" erhhen.
                                            'ODER: Nicht verwendete Bereiche einschalten,
                                            '      aber minimieren!
            If Bericht.Section(Zahl).Visible = True Then        'Wenn der Bereich Nummer xy nicht
                                                                'vorhanden ist, wird durch die
                                                                'Fehlerbehandlung die Routine beendet.
                'Controls-Auflistung durchlaufen
                For Each ctl In Bericht.Section(Zahl).Controls
                    'Prfen, ob das Element ein Textfeld ist
                    If ctl.ControlType = acTextBox Then
                        'Eigenschaften des Elements einstellen
                        If SchriftArtWahl = "Arial" Then ctl.FontName = "Arial"
                        If SchriftArtWahl = "Times" Then ctl.FontName = "Times New Roman"
                    End If
                    'Prfen, ob das Element ein Bezeichner ist
                    If ctl.ControlType = acLabel Then
                        'Eigenschaften des Elements einstellen
                        If SchriftArtWahl = "Arial" Then ctl.FontName = "Arial"
                        If SchriftArtWahl = "Times" Then ctl.FontName = "Times New Roman"
                    End If
'                    'Prfen, ob das Element eine Optionsgruppe ist
'                    If ctl.ControlType = acLabel Then
'                        'Eigenschaften des Elements einstellen
'                        If SchriftArtWahl = "Arial" Then ctl.FontName = "Arial"
'                        If SchriftArtWahl = "Times" Then ctl.FontName = "Times New Roman"
'                    End If
                Next ctl
            End If
        Next Zahl
    End If

SchriftartFuerBerichtEinstellen_Ende:
    Exit Sub
    
SchriftartFuerBerichtEinstellen_ERR:
    Resume SchriftartFuerBerichtEinstellen_Ende

End Sub

Public Sub RechnungPositionenStorno()
    Dim stDocName As String
    Dim stLinkCriteria As String

Set dbs = CurrentDb

    'Fortschrittsdialog auf den Schirm bringen
    stDocName = "Rechnungsstorno"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    'Anzeigen fllen...
    'Nach Kontaktdetails suchen
    FilterKontakt = "SELECT * FROM Kunden WHERE [lfd_Nr] = " & rstRechnungen!lfd_Nr_Kunde
    Set rstKontakte = dbs.OpenRecordset(FilterKontakt)
        Forms!Rechnungsstorno.Re_Kunde.Caption = rstKontakte!Name1
    rstKontakte.Close
    'Rechnungspositionen suchen
    FilterRechnungen = "SELECT * FROM Rechnungsdetails WHERE [lfd_Nr_Re] = " & ReNrIntern
    Set rstRechnungsdetails = dbs.OpenRecordset(FilterRechnungen)
    If (rstRechnungsdetails.RecordCount <> 0) Then rstRechnungsdetails.MoveLast
    Forms!Rechnungsstorno.Re_Position_gesamt.Caption = rstRechnungsdetails.RecordCount
    Forms!Rechnungsstorno.Re_Rechnungsnummer.Caption = ReNummer
    Forms!Rechnungsstorno.Re_Betrag.Caption = ReGesamtNetto
    ShowProgress Forms!Rechnungsstorno.Verlauf_Balken, 1, 100
    NummeroGesamt = rstRechnungsdetails.RecordCount
    NummeroTermin = 0
    
    'alle gefundenen Rechnungspositionen durchgehen
    rstRechnungsdetails.MoveFirst
    Do While Not rstRechnungsdetails.EOF
        'Zhler und Anzeige aktualisieren
        NummeroTermin = NummeroTermin + 1
        ShowProgress Forms!Rechnungsstorno.Verlauf_Balken, NummeroTermin - 1, NummeroGesamt
        Forms!Rechnungsstorno.Re_Position_aktuell.Caption = NummeroTermin
        Forms!Rechnungsstorno.Re_Termindatum.Caption = rstRechnungsdetails!Start
        Forms!Rechnungsstorno.Repaint
        
        'Tabelle "aktuelle Termine" bzw. "gelschte Termine" aktualisieren
        FilterTermin = "SELECT * FROM Termine WHERE [lfd_Nr] = " & rstRechnungsdetails!lfd_Nr_Termin
        Set rstTermine = dbs.OpenRecordset(FilterTermin)
        If rstTermine.RecordCount <> 0 Then         '...wenn Termin noch nicht gelscht
            rstTermine.Edit
            'alt: rstTermine!Su_Re_Netto = rstTermine!Su_Re_Netto - rstRechnungsdetails!Netto
            rstTermine!Su_Re_Netto = rstTermine!Su_Re_Netto - rstRechnungsdetails!Netto - rstRechnungsdetails!km_Netto
            'Marker fr Hinweis auf Negativsaldo setzen
            If (rstTermine!Su_Re_Netto < 0) Then StornoTerminNegativsaldo = True
            'wenn Stornooption = 2 (Termin fr Neuberechnung kennzeichnen)
            If ReStornoOption = 2 Then rstTermine!geaendert_seit_Re = True
            rstTermine.Update
            rstTermine.Close
        Else                                        '...wenn Termin bereits gelscht wurde
            'Achtung: In den gelschten Terminen wird im FilterTermin ein anderes Datenfeld angesprochen!
            FilterTermin = "SELECT * FROM Termine_geloescht WHERE [lfd_Nr_Termin] = " & rstRechnungsdetails!lfd_Nr_Termin
            Set rstTermine = dbs.OpenRecordset(FilterTermin)
            rstTermine.Edit
            'alt: rstTermine!Su_Re_Netto = rstTermine!Su_Re_Netto - rstRechnungsdetails!Netto
            rstTermine!Su_Re_Netto = rstTermine!Su_Re_Netto - rstRechnungsdetails!Netto - rstRechnungsdetails!km_Netto
            'Marker fr Hinweis auf Negativsaldo setzen
            If (rstTermine!Su_Re_Netto < 0) Then StornoTerminNegativsaldo = True
                'wenn Stornooption = 2 (Termin fr Neuberechnung kennzeichnen)
                'macht bei gelschtem Termin keinen Sinn...
                '   If ReStornoOption = 2 Then rstTermine!geaendert_seit_Re = True
            rstTermine.Update
            rstTermine.Close
        End If
        
        'Tabelle der berechneten Monatsanteile des Termins aktualisieren
        FilterAbgerechnet = "SELECT * FROM Termine_berechnet WHERE " & _
            "(([lfd_Nr_Termin] = " & rstRechnungsdetails!lfd_Nr_Termin & _
            ") AND ([Jahr] = " & Year(rstRechnungsdetails!MMJJJJ_fuer_Re) & _
            ") AND ([Monat] = " & Month(rstRechnungsdetails!MMJJJJ_fuer_Re) & "))"
        Set rstAbgerechnet = dbs.OpenRecordset(FilterAbgerechnet)
            'Wenn Termin bereits entfernt wurde, wurden auch evtl. Monatsbetrge gelscht, da der Termin
            'sowieso nicht mehr fr Rechnungen herangezogen wird. Der Saldo zu dem Termin wird dann nur
            'noch beim (gelschten) Termin selbst gefhrt (s.o.).
'>>>>>>>     ....Ist zu berdenken, da ja negative Salden von gelschten Terminen wieder
            '    verrechnet werden sollen knnen!
        
        If rstAbgerechnet.RecordCount <> 0 Then
            rstAbgerechnet.Edit
            rstAbgerechnet!Netto = rstAbgerechnet!Netto - rstRechnungsdetails!Netto
            rstAbgerechnet!km_Netto = rstAbgerechnet!km_Netto - rstRechnungsdetails!km_Netto
            rstAbgerechnet.Update
        End If
        rstAbgerechnet.Close
        
        'nchste Rechnungsposition
        rstRechnungsdetails.MoveNext
    Loop                        'gefundene Rechnungspositionen durchgehen
    
    'Tabelle schlieen
    rstRechnungsdetails.Close
    
    'Fortschrittsdialog wieder schlieen
    DoCmd.Close acForm, "Rechnungsstorno", acSaveNo
    
    
End Sub

Sub SplitPath(ByVal sSourcePath As String, ByRef sDrive As String, _
              ByRef sPath As String, ByRef sFilename As String, _
              ByRef sExtension As String)
 
    Dim iOffset As Integer
'// ------------------------------------------------------------------------
'// Zunchst den ersten Backslash suchen
'// ------------------------------------------------------------------------
    iOffset = InStr(sSourcePath, "\")
    If iOffset = 0 Then Exit Sub 'da ungltiger Dateipfad
'// ------------------------------------------------------------------------
'// Laufwerksbuchstaben ohne Backslash merken
'// ------------------------------------------------------------------------
    sDrive = Left(sSourcePath, iOffset - 1)
'// ------------------------------------------------------------------------
'// Jetzt den Ordner ermitteln
'// ------------------------------------------------------------------------
    sPath = Mid(sSourcePath, iOffset + 1)
'// ------------------------------------------------------------------------
'// In String fr den Ordner befindet sich jetzt noch der Dateiname,
'// also den String bis zum letzten Backslash rckwrts durchsuchen
'// ------------------------------------------------------------------------
    For iOffset = Len(sPath) To 1 Step -1
        If Mid(sPath, iOffset, 1) = "\" Then
        '// Letzten Backslash gefunden
            sFilename = Mid(sPath, iOffset + 1)
            sPath = Left(sPath, iOffset - 1)
            Exit For
        End If
    Next
'// ------------------------------------------------------------------------
'// Dateiendung ermitteln; da es mehrere Punkte in einem Dateinamen
'// geben darf, zhlt hier nur der letzte.
'// ------------------------------------------------------------------------
    If Len(sFilename) > 0 Then
    For iOffset = Len(sFilename) To 1 Step -1
        If Mid(sFilename, iOffset, 1) = "." Then
        '// Letzten Punkt gefunden
            sExtension = Mid(sFilename, iOffset + 1)
            sFilename = Left(sFilename, iOffset - 1)
            Exit For
        End If
    Next
    End If
 
End Sub

Public Sub CoSuchen()

    'Sucht alle Ordner eines bestimmten Typs in Outlook und speichert deren EntryID und StoreID in Arrays
    'Welcher Typ gesucht wird, wird in der nchsten Sub "CoPruefen" festgelegt
    
    Dim x As Integer, a As Integer, b As Integer, c As Integer, d As Integer
    Dim OrdnerAnzahl As Integer
    Dim olkAnwCo As Object, meinNamespaceCo As Object
    Dim myNode As Object, myFolder As Object, myFolder0 As Object, myFolder1 As Object, myFolder2 As Object, myFolder3 As Object
    
    CoOrdner = Array("")
    CoContainer = Array("")

    ReDim CoOrdner(0)
    ReDim CoContainer(0)
    
    CoIndex = -1                ' wird vor Hinzufgen um 1 erhht
    CoOrdner(0) = ""
    CoContainer(0) = ""
    
    Set olkAnwCo = CreateObject("outlook.application")
    Set meinNamespaceCo = olkAnwCo.GetNamespace("MAPI")
    
    'Einlesen der Ordnerstruktur von Outlook
    For Each myFolder0 In meinNamespaceCo.Folders             'Postfcher
        
        'Test+Fehlerbehandlung, ob Unterodner lesbar sind (fr Kontainer mit Kennwortschutz oder Fehler)
        On Error GoTo Err_NichtLesbar_1
        OrdnerAnzahl = 0
        OrdnerAnzahl = myFolder0.Folders.Count
        
        If OrdnerAnzahl > 0 Then
            For Each myFolder1 In myFolder0.Folders             '1.Unterordner
                CoPruefen myFolder1
                'Test+Fehlerbehandlung, ob Unterodner lesbar sind (fr Kontainer mit Kennwortschutz oder Fehler)
                    On Error GoTo Err_NichtLesbar_2
                    OrdnerAnzahl = 0
                    OrdnerAnzahl = myFolder1.Folders.Count
                If OrdnerAnzahl > 0 Then
                    For Each myFolder2 In myFolder1.Folders         '2.Unterordner
                        CoPruefen myFolder2
                        'Test+Fehlerbehandlung, ob Unterodner lesbar sind (fr Kontainer mit Kennwortschutz oder Fehler)
                        On Error GoTo Err_NichtLesbar_3
                            OrdnerAnzahl = 0
                            OrdnerAnzahl = myFolder2.Folders.Count
                        If OrdnerAnzahl > 0 Then
                            For Each myFolder3 In myFolder2.Folders     '3.Unterordner
                                CoPruefen myFolder3
                            Next myFolder3
                        End If
                        GoTo Nach_Err_NichtLesbar_3     'im Normallauf die Fehlerbehandlung berspringen
Err_NichtLesbar_3:
                        Resume Behandlung_Err_NichtLesbar_3
Behandlung_Err_NichtLesbar_3:
                        ' mgliche Fehlerbehandlung
                        ' ...
Nach_Err_NichtLesbar_3:
                    Next myFolder2
                End If
                GoTo Nach_Err_NichtLesbar_2     'im Normallauf die Fehlerbehandlung berspringen
Err_NichtLesbar_2:
                Resume Behandlung_Err_NichtLesbar_2
Behandlung_Err_NichtLesbar_2:
                ' mgliche Fehlerbehandlung
                ' ...
Nach_Err_NichtLesbar_2:
            Next myFolder1
        End If
        GoTo Nach_Err_NichtLesbar_1     'im Normallauf die Fehlerbehandlung berspringen
Err_NichtLesbar_1:
        Resume Behandlung_Err_NichtLesbar_1
Behandlung_Err_NichtLesbar_1:
        ' mgliche Fehlerbehandlung
        ' ...
Nach_Err_NichtLesbar_1:
    Next myFolder0
    
    Set meinNamespaceCo = Nothing
    Set olkAnwCo = Nothing
    
End Sub

Public Sub CoPruefen(ByRef CoFolder As Object)          ' ... As Outlook.Folder
    
    ' Folder.DefaultItemType
    ' ---------------------------
    '  0 = olMailItem
    '  1 = olAppointmentItem
    '  2 = olContactItem
    '  3 = olTaskItem
    '  4 = olJournalItem
    '  5 = olNoteItem
    '  6 = olPostItem
    '  7 = olDistributionListItem
    ' 11 = olMobileItemSMS
    ' 12 = olMobileItemMMS
    
    If CoFolder.DefaultItemType = 2 Then            ' 2 = olContactItem
        CoIndex = CoIndex + 1
        ReDim Preserve CoOrdner(CoIndex)
        ReDim Preserve CoContainer(CoIndex)
        CoOrdner(CoIndex) = CoFolder.EntryID
        CoContainer(CoIndex) = CoFolder.StoreID
    End If
    
End Sub

Public Sub Zaehler_in_Merfachwahl_PreisNeu_aktualisieren()
    Dim dbs As Database
    Dim rst As Recordset
    Dim txt As String
    Dim Gesamt As String
    
    Set dbs = CurrentDb
    
    'Anzeige der berschneidungen aktualisieren
    'Gesamtzahl von Gilt-ab_Datum betroffener Eintrge
    Set rst = dbs.OpenRecordset("SELECT Betrag FROM Mehrfachwahl WHERE Betrag <> -999999.99")
    If rst.RecordCount > 0 Then
        rst.MoveLast        'auffllen
        Gesamt = Format(rst.RecordCount, "###,##0")
        rst.Close
        'Unter-Anzahl der betroffnen Eintrge (fr aktuelle berschrift)
        Select Case Mehrfachwahl_Primaer
            Case "Kalender"
                txt = "SELECT Betrag FROM Mehrfachwahl WHERE Betrag <> -999999.99 AND " & _
                        " Tab1_lfd_Nr = " & Forms![Mehrfachwahl_PreisNeu]![lfd_Nr].Value
            Case "Kategorie"
                txt = "SELECT Betrag FROM Mehrfachwahl WHERE Betrag <> -999999.99 AND " & _
                        " Tab2_lfd_Nr = " & Forms![Mehrfachwahl_PreisNeu]![lfd_Nr].Value
            Case "NurKalender"
                txt = "SELECT Betrag FROM Mehrfachwahl WHERE Betrag <> -999999.99 AND " & _
                        " Tab2_lfd_Nr = " & SatzKategorieDummy
            Case "NurKategorien"
                txt = "SELECT Betrag FROM Mehrfachwahl WHERE Betrag <> -999999.99 AND " & _
                        " Tab1_lfd_Nr = 0"      'Kalender-"Dummy"
        End Select
        Set rst = dbs.OpenRecordset(txt)
        If rst.RecordCount > 0 Then
            rst.MoveLast    'auffllen
            'Me.Mehrfachwahl_UF1!Bez_Vorhanden.Caption = Format(rst.RecordCount, "###,##0") & " / " & Gesamt
            Forms![Mehrfachwahl_PreisNeu].[Mehrfachwahl_UF1]![Bez_Vorhanden].Caption = Format(rst.RecordCount, "###,##0") & " / " & Gesamt
        Else
            'Me.Mehrfachwahl_UF1!Bez_Vorhanden.Caption = "0 / " & Gesamt
            Forms![Mehrfachwahl_PreisNeu].[Mehrfachwahl_UF1]![Bez_Vorhanden].Caption = "0 / " & Gesamt
        End If
        'Me.Datum_Achtung.Visible = True
        Forms![Mehrfachwahl_PreisNeu]![Datum_Achtung].Visible = True
        rst.Close
    Else
        'Me.Mehrfachwahl_UF1!Bez_Vorhanden.Caption = "0 / 0"
        Forms![Mehrfachwahl_PreisNeu].[Mehrfachwahl_UF1]![Bez_Vorhanden].Caption = "0 / 0"
        'Me.Datum_Achtung.Visible = False
        Forms![Mehrfachwahl_PreisNeu]![Datum_Achtung].Visible = False
        rst.Close
    End If
    
    
    'Anzeige der HkchenAnzahl aktualisieren
    Set rst = dbs.OpenRecordset("SELECT Auswahl FROM Mehrfachwahl WHERE Auswahl = True")
    If rst.RecordCount > 0 Then
        rst.MoveLast        'auffllen
        Gesamt = Format(rst.RecordCount, "###,##0")
        rst.Close
        'Unter-Anzahl der betroffnen Eintrge (fr aktuelle berschrift)
        Select Case Mehrfachwahl_Primaer
            Case "Kalender"
                txt = "SELECT Betrag FROM Mehrfachwahl WHERE Auswahl = True AND " & _
                        " Tab1_lfd_Nr = " & Forms![Mehrfachwahl_PreisNeu]![lfd_Nr].Value
            Case "Kategorie"
                txt = "SELECT Betrag FROM Mehrfachwahl WHERE Auswahl = True AND " & _
                        " Tab2_lfd_Nr = " & Forms![Mehrfachwahl_PreisNeu]![lfd_Nr].Value
            Case "NurKalender"
                txt = "SELECT Betrag FROM Mehrfachwahl WHERE Auswahl = True AND " & _
                        " Tab2_lfd_Nr = " & SatzKategorieDummy
            Case "NurKategorien"
                txt = "SELECT Betrag FROM Mehrfachwahl WHERE Auswahl = True AND " & _
                        " Tab1_lfd_Nr = 0"      'Kalender-"Dummy"
        End Select
        Set rst = dbs.OpenRecordset(txt)
        If rst.RecordCount > 0 Then
            rst.MoveLast    'auffllen
            'Me.Mehrfachwahl_UF1!Bez_Hakenanzahl.Caption = Format(rst.RecordCount, "###,##0") & " / " & Gesamt
            Forms![Mehrfachwahl_PreisNeu].[Mehrfachwahl_UF1]![Bez_Hakenanzahl].Caption = Format(rst.RecordCount, "###,##0") & " / " & Gesamt
        Else
            'Me.Mehrfachwahl_UF1!Bez_Hakenanzahl.Caption = "0 / " & Gesamt
            Forms![Mehrfachwahl_PreisNeu].[Mehrfachwahl_UF1]![Bez_Hakenanzahl].Caption = "0 / " & Gesamt
        End If
        rst.Close
    Else
        'Me.Mehrfachwahl_UF1!Bez_Hakenanzahl.Caption = "0 / 0"
        Forms![Mehrfachwahl_PreisNeu].[Mehrfachwahl_UF1]![Bez_Hakenanzahl].Caption = "0 / 0"
        rst.Close
    End If
    
    
    
    ' Anzeige aktualisieren
    'Me.Mehrfachwahl_UF1.Form.Requery
    'Folgende Zeile daaktiviert, da sonst immer der 1. Eintrag ganz oben in der Liste zum Aktiven gemacht wird:
    '   Forms![Mehrfachwahl_PreisNeu].[Mehrfachwahl_UF1].Form.Requery
    'Me.Mehrfachwahl_UF1.Form.Repaint
    Forms![Mehrfachwahl_PreisNeu].[Mehrfachwahl_UF1].Form.Repaint
    
End Sub


Public Function DateiAuslesen(Dateipfad As String) As String
 
   'Quelle: www.dbwiki.net oder www.dbwiki.de
 
   'Verwendet Late Binding. Deshalb ist kein Verweis auf
   'die "Microsoft Scriping Runtime" notwendig.
 
   On Error Resume Next
 
   DateiAuslesen = CreateObject("Scripting.FileSystemObject") _
      .OpenTextFile(Dateipfad).ReadAll
 
End Function


Public Function ANSIzuUTF8String(ANSIText As String, _
                                 Optional ByVal ohneBOM As Boolean = False) As String
 
   'Konvertiert einen ANSI-Textstring ins UTF8-Format
   'Late-Binding, kein Verweis auf Microsoft ActiveX Data Objects X.X Library (ADO) notwendig
 
   'Quelle: www.dbwiki.net oder www.dbwiki.de
 
   Const adTypeText = 2
   Const adSaveCreateOverWrite = 2
 
   Dim objStreamANSI As Object 'ADODB.Stream
   Dim objStreamUTF8 As Object 'ADODB.Stream
   Dim strtempdatei As String
   Dim strret As String
 
   Set objStreamANSI = CreateObject("ADODB.Stream")
   Set objStreamUTF8 = CreateObject("ADODB.Stream")
 
   'Streamobjekt Quelle ffnen, Kodierung ANSI-Text
   objStreamANSI.Type = adTypeText
   objStreamANSI.Charset = "Windows-1252"
   objStreamANSI.Open
 
   'String in den Stream bernehmen
   objStreamANSI.WriteText ANSIText
 
   'Streamobjekt Ziel ffnen, Kodierung UTF8-Text
   objStreamUTF8.Type = adTypeText
   objStreamUTF8.Charset = "utf-8"
   objStreamUTF8.Open
 
   'Text vom Streamobjekt Quelle ins Streamobjekt Ziel kopieren
   objStreamANSI.Position = 0
   objStreamUTF8.WriteText objStreamANSI.ReadText
 
   'in temporre UTF8-Datei speichern
   strtempdatei = CurrentProject.Path & "\temp.txt"
   objStreamUTF8.SaveToFile strtempdatei, adSaveCreateOverWrite

   'UTF8-Text aus temporrer Datei auslesen
   'Die Funktion "DateiAuslesen" ist im DBWiki zu finden
   strret = DateiAuslesen(strtempdatei)

   'BOM (﻿, entspricht den Zeichen 239 187 191) entfernen
   If ohneBOM = True Then
      strret = Replace(strret, Chr(239) & Chr(187) & Chr(191), "", , , vbBinaryCompare)
   End If

   'Rckgabewert setzen
   ANSIzuUTF8String = strret
 
   'temporre Datei lschen
   Kill strtempdatei
 
   'Objekte schlieen und Speicher leeren
   objStreamUTF8.Close: Set objStreamUTF8 = Nothing
   objStreamANSI.Close: Set objStreamANSI = Nothing
 
End Function

